//
//  Settings.swift
//  Orbis
//
//  Created by KALSI on 7/3/17.
//  Copyright © 2017 KALSI. All rights reserved.
//

import UIKit

class Settings: UIViewController {
    
    @IBOutlet weak var nameTF: UITextField!
    @IBOutlet weak var addressTF: UITextField!
    @IBOutlet weak var emailTF: UITextField!
    @IBOutlet weak var contactTF: UITextField!

    // MARK: -
    override func viewDidLoad() {
        super.viewDidLoad()
        
        nameTF.text = ProfileInfoModel.sharedInstance.fullname
        addressTF.text = ProfileInfoModel.sharedInstance.address
        emailTF.text = ProfileInfoModel.sharedInstance.emailaddress
        contactTF.text = ProfileInfoModel.sharedInstance.number
//        appDelegate.isBluetooth

    }
    
    override func viewWillAppear(_ animated: Bool) {
      //  super.viewWillAppear()
        if appDelegate.isBluetooth{
            self.navigationController?.popViewController(animated: false)
        }
    }
    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
    }
    // MARK: -
    
    @IBAction func GoBack(_ sender: Any) {
        self.navigationController?.popViewController(animated: true)
    }
    
    @IBAction func EscalationDetailsAction(_ sender: UIButton) {
        let vc = self.storyboard?.instantiateViewController(withIdentifier: "EscalationDetails") as! EscalationDetails
        self.navigationController?.pushViewController(vc, animated: true)
    }
    @IBAction func LogOutAction(_ sender: UIButton) {
        Globals().SendSignalToARC(controllerObject:self , signalType: Constants.sLogout)
        Globals().killTimers()
        UserDefaults.standard.set(false, forKey: "isLogged")
        UserDefaults.standard.synchronize()
        let vc = self.storyboard?.instantiateViewController(withIdentifier: "Login") as! Login
        self.navigationController?.pushViewController(vc, animated: false)
    }
    
    @IBAction func pairBTClck(_ sender: Any) {
        let vc = self.storyboard?.instantiateViewController(withIdentifier: "PeripheralDevice") as! PeripheralDevice
        self.navigationController?.pushViewController(vc, animated: true)
    }
    
    @IBAction func termsNdConditions(_ sender: Any) {
        guard let termsNdCondURl = URL(string: "http://redalert.orbisprotect.com/iphone/orbis/terms") else { return }
        UIApplication.shared.open(termsNdCondURl)
     //        [[UIApplication .shared] openURL:[NSURL URLWithString:@"http://www.apple.com"]];
    }
    
    @IBAction func privacyPolicy(_ sender: Any) {
        guard let termsNdCondURl = URL(string: "http://redalert.orbisprotect.com/iphone/orbis/privacy") else { return }
        UIApplication.shared.open(termsNdCondURl)
    }
    
}
